function img = ml_gaussimg( sigma, param )
%ML_GAUSSIMG Synthesize an image from a 3D Gaussian distribution.
%   IMG = ML_GAUSSIMG(SIGMA) returns an image that has intensities with
%   a 3D Gaussian distribution. SIGMA is the 2x2 covariance matrix of the 
%   Gaussian distribution.

% 26-Jan-2006 T. Zhao
%
% Copyright (C) 2007-2012 Murphy Lab
% Carnegie Mellon University
%
% August 4, 2012 D. Sullivan added param structure to the method, param.imagesize
%       contains the size of the cell image which the objects will be added.
%       This is used to make sure we don't waste memory making object
%       images that can't fit in the final image. 
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu

if nargin < 1
    error('Exactly 1 arguments are required')
end

imageSize = ceil([6*sqrt(sigma(1,1)),...
    6*sqrt(sigma(2,2)),6*sqrt(sigma(3,3))]);

%devins 8/4/2012 check if too large for image
imageSize = min([imageSize;param.imagesize]);

x = ml_imcoords(imageSize,1,-round(imageSize/2))';
img = reshape(mvnpdf(x,[0 0 0],sigma),...
    imageSize(1),imageSize(2),imageSize(3));
