function spfeat = gmm_allnucspfeat( method, dnaimgdir, param )

% Author: Tao Peng
% Edited: Ivan E. Cao-Berg
%
% Copyright (C) 2011 Murphy Lab
% Lane Center for Computational Biology
% School of Computer Science
% Carnegie Mellon University
%
% July 23, 2012 R.F. Murphy Add param and make default verbose
% August 2, 2012 I. Cao-Berg Fixed bug where the image directory loop
%                   would ignore the first two images
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu

if nargin == 2
   param = [];
end

try
  verbose = param.verbose;
catch
  param.verbose = true;
end

try
  debug = param.debug;
catch
  param.debug = true;
end

spfeat = {};
directory = ml_dir([dnaimgdir filesep 'cell*']);

%icaoberg 2/8/2012
for i = 1:1:length( directory )
    image = directory{i};
    imgdir = [dnaimgdir filesep image];
    disp( ['Image:' num2str(i-2) ' in ' imgdir] );
    if exist( imgdir, 'dir' )
        try
            temp = tp_nucimgfeat(imgdir,method,param);
            temp.directory = imgdir;
            if ~isempty( temp )
                spfeat{length(spfeat)+1} = temp;
                disp( 'Features successfully calculated' );
            else
                continue
            end
        catch err
            % need to handle this error
            disp( 'Unable to calculate features' );
            continue
        end
    end
end
end
