function test_generate_frame_from_model_no_compression()
% Generate a frame from a trained shape space model.
% Dependencies from File Exchange:
% inhull
% sort_nat
% export_fig
% CompressionLib
% ode2stab
% convnfft
% DataHash
% Dependencies from the Murphy and Rohde labs:
% ./renuclearmorphometrycode
% ./Taraz
% /home/icaoberg.projects/slic
% 
% 2012-09-17 15:55 tebuck: Copied from
% test_generate_frame_from_trained_shape_space_model.m.

  start_time = tic;

  addpath(genpath('./inhull'));
  addpath(genpath('./sort_nat'));
  addpath(genpath('./export_fig'));
  addpath(genpath('./CompressionLib'));
  addpath(genpath('./ode2stab'));
  addpath(genpath('./convnfft'));
  addpath(genpath('./DataHash'));
  % addpath(genpath('./renderpatch_version0'));
  addpath(genpath('./renuclearmorphometrycode'));
  addpath(genpath('/home/icaoberg.projects/slic'));
  addpath(genpath('./Taraz'));

  % I like to use mfilename and parameter identifiers so that tests
  % do not overwrite the results of previous tests:
  filename = mfilename;
  base_filename = [filename, '/'];

  warning('off', 'MATLAB:MKDIR:DirectoryExists');
  mkdir(filename)

  n = getenv('PBS_JOBID');
  n = regexprep(n, '[\r\n]', '');
  date_text = datestr(now(), 'yyyymmddHHMMSSFFF');
  diary([base_filename, 'log', date_text, '_', n, '.txt']);

  
  
  % Combine dual model files from test_walk_ternary023 and test_walk_ternary023c 
  %(Nuc and Tub sets) into single ones (this really only needs to be done once, 
  % but I didn't want to hand Ivan more magic .mat files):

  % Spacing is now defined based on Jieyue's/Aabid's preprocessing
  % method (which creates images that are 256 x 256 in the XY plane):
  spacing = 1;
  
  model_directory = 'test_walk_ternary023c_model';
  registration_filename = ['test_walk_ternary023', '/', 'registration', num2str(spacing, '_spacing%05d')];
  nuclear_registration_filename = ['test_walk_ternary023c', '/', 'registration_nuclear', num2str(spacing, '_spacing%05d')];
  complete_registration_filename = [model_directory, '/', 'registration', num2str(spacing, '_spacing%05d')];
  a = load(registration_filename);
  b = load(nuclear_registration_filename);
  % a, b
  % Yes, some of these are oriented differently:
  a.centroids = [a.centroids; b.novel_centroids];
  a.image_centered_params = [a.image_centered_params; b.novel_image_centered_params];
  a.image_aligned_params = [a.image_aligned_params, b.novel_image_aligned_params];
  a.image_registration_params = [a.image_registration_params; b.novel_image_registration_params];
  a.registered_shapes = [a.registered_shapes; b.novel_registered_shapes'];
  a.mean_image = b.novel_mean_image;
  save(complete_registration_filename, '-struct', 'a');

  % Just move this one:
  shape_space_filename = ['test_walk_ternary023c', '/', 'shape_space', num2str(spacing, '_spacing%05d')];
  complete_shape_space_filename = [model_directory, '/', 'shape_space', num2str(spacing, '_spacing%05d')];
  a = load(shape_space_filename);
  save(complete_shape_space_filename, '-struct', 'a');

  
  % Part that always happens:
  
  
  % use_profiling = false;
  use_profiling = true;

  if use_profiling
    profile('-memory','on'); profile reset; profile on;
  end
  
  
  try
    load(shape_space_filename)
    number_shapes = size(y2, 1);

    RandStream.setDefaultStream(RandStream('mt19937ar', 'Seed', 309));

    % Generate a random point inside the convex hull of training shapes in the
    % shape space (probably not uniform sampling):
    random_weights = rand(number_shapes, 1);
    random_weights = random_weights ./ sum(random_weights);
    random_point = random_weights' * y2;
    
    % Generate the shape associated with that point:
    options = struct();
    options.use_compression = false;
    
    frame = generate_frame_from_trained_shape_space_model(model_directory, random_point, options);
    image_filename = [base_filename, 'generated_frame.png'];
    whos
    frame
    imwrite(reshape_contrast(round(frame.interpolated_image.get_data())), image_filename)
  catch err
    err(:)
    err.message
    for m=1:length(err.stack)
      err.stack(m)
    end
  end
  
  if use_profiling
    p = profile('info');
    profile_filename = [base_filename, 'profile_results', '.mat'];
    profsave(p, profile_filename);
    save([profile_filename, '.mat'], 'p');
  end
  
  diary('off')

end

