function [lambda,ordering] = shape_interp_track(x,c)
%SHAPE_INTERP_TRACK calculates the interpolation order to generate a shape
%inside the high-dimensional triangle using the vertices

[m,n] = size(x);
if m ~= n-1 || n < 3
    error('Not a triangle!')
end

lambda = zeros(1,n-1);
ordering = zeros(1,n);
norder = 1:n;
for i = 1:n-2
    % Order the vertices
    distseq = sum((x-repmat(c,1,size(x,2))).^2,1);
    [mindist,minidx] = min(distseq);
    x1 = x(:,minidx);
    x(:,minidx) = [];
    ordering(i) = norder(minidx);
    norder(minidx) = [];
    % Calculate segmentation ratio
    Num = x - repmat(x(:,1),1,size(x,1));
    Num(:,1) = c - x(:,1);
    Den = Num;
    Den(:,1) = c - x1;
    lambda(i) = - det(Num) / det(Den);
    % Dimension reduction
    w = [c+lambda(i)*(c-x1),x]';
    [coef,w] = princomp(w);
    w(:,end) = [];
    c = w(1,:)';
    x = w(2:end,:)';
end
dist = abs(x-c);
[mindist,minidx] = min(dist);
dist(minidx) = [];
lambda(n-1) = dist / mindist;
ordering(n-1) = norder(minidx);
norder(minidx) = [];
ordering(n) = norder;