function r_structure = render_point_3d_windowed(...
  point, shape_space, image_function, epsilon, ...
  options )

%
% Copyright (C) 2012 Murphy Lab
% Lane Center for Computational Biology
% School of Computer Science
% Carnegie Mellon University
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu

% $$$   point, shape_space, images, epsilon, ...
% $$$   options)
  
% $$$   [M, N, P] = size(CompressLib.decompress(images{1}));
  [M, N, P] = size(image_function(1));
  window_size = options.window_radius * [1, 1, 0] + [0, 0, P];

  
  Y2 = shape_space{1};
  convex_hull = shape_space{2};
  tes = shape_space{3};


  %Locate sample point in triangle mesh
  %Y2, tes, point
  simplex_idx = tsearchn(Y2,tes,point);
  xidx = tes(simplex_idx,:);
  xtri = Y2(xidx,:);

  distances = sqrt( sum( (xtri-repmat( point, [length(xidx),1])).^2, 2 ));
  [minv,idx] = min( distances );

  compression_method = 'none';
  if isfield(options, 'use_compression') && options.use_compression
    compression_method = 'gzip';
  end
  
  if distances(idx)<= epsilon
    % r_structure.interpolated_image = window_compress_image(...
      % image_function(xidx(idx)), ...
      % window_size);
    r_structure.interpolated_image = WindowedImage(...
      image_function(xidx(idx)), window_size, compression_method);
    r_structure.total_wall_time = 0;
    r_structure.total_cpu_time = 0;
    return
  end

  % Shape interpolation path
  [lambda,ordering] = shape_interp_track(xtri',point');
  ordering = xidx(ordering);

% $$$   temp = images{ordering(end)};
% $$$   temp = CompressLib.decompress(temp);
  temp = image_function(ordering(end));
  total_wall_time = 0;
  total_cpu_time = 0;
  for i=length(lambda):-1:1
    amount = lambda(i);
% $$$     start = images{ordering(i)};
% $$$     start = CompressLib.decompress(start);
    start = image_function(ordering(i));
    last = temp;
    if isfield(options, 'registration_error_function')
      options.convergence_registration_error = ...
          options.registration_error_function(start, last);
    end
    
    ri = Greedy3D_lambda_pre_compressed(...
      start, last, amount, options);
    % temp = window_decompress_image(ri.interpolated_image);
    temp = ri.interpolated_image.get_data();
    total_wall_time = total_wall_time + ri.total_wall_time;
    total_cpu_time = total_cpu_time + ri.total_cpu_time;
  end

  %image = temp;
  % r_structure.interpolated_image = window_compress_image(...
    % temp, window_size);
  r_structure.interpolated_image = WindowedImage(...
    temp, window_size, compression_method);
  r_structure.total_wall_time = total_wall_time;
  r_structure.total_cpu_time = total_cpu_time;
