function [result, success] = register_shapes_to_mean_shape(...
  image_functions, number_registrations, save_filenames, registration_options, convergence_error_function)
  % [result, success] = register_shapes_to_mean_shape(...
  %   image_functions, number_registrations, number_slices,
  %   save_filenames, registration_options)
  %
  %   Parallel.
  %   
  %   
  
  %error('Implementation yet unfinished below this line!')
  
  result = [];
  
  %success = false;
  success = true;
  for registration_index = 1:number_registrations
    % Check if work has been done
    save_filename = save_filenames{registration_index}; 
    [can_start, final_name, final_exists] = ...
        chunk_start('.', save_filename);
    if (~can_start)
      stack = dbstack();
      warning('Skipping "%s" at line %d in file %s.', ...
              save_filename, stack(1).line, stack(1).file)
      if final_exists
      else
        success = false;
        warning('  Being computed elsewhere.')
      end
    else
      % Get image
      source = image_functions{1}(registration_index); 
      target = image_functions{2}(registration_index); 
      % Perform work
      %source = CompressLib.decompress(registered_shapes{registration_index}); 
      %target = CompressLib.decompress(registered_shapes{reference_index}); 
      registration_options.convergence_registration_error = ...
          convergence_error_function(source, target);
      registration_options.single_sided = true;
      registration_options

      r = Greedy3D_lambda_pre_compressed(...
        source, target, 0, registration_options)
      
      % Save work
      save([save_filename '.mat'], 'r')
      chunk_finish('.', save_filename); 
    end
    
  end

  success = true;
