function [options] = process_options_structure(default_options, options)
% Dependencies:
% 2012-10-31 tebuck: Created.

  if nargin == 1
    options = default_options; 
  else
    option_names = fieldnames(default_options); 
    for index = 1:length(option_names)
      current_option = option_names{index}; 
      if ~isfield(options, current_option)
        options = setfield(options, current_option, getfield(default_options, current_option)); 
      end
    end
  end
  
