function [result, success] = generate_walk_path(...
  shape_space, walk_type, diffusion_constant, dt, mmax, save_filename)
  % [result, success] = generate_walk_path(...
  %   y2, convex_hull, tes, save_filename)
  %
  %   
  
  %error('Implementation yet unfinished below this line!')
  
  [y2, convex_hull, tes] = shape_space{:}; 
  result = struct();
  result.walk_path = [];
  result.start_index = [];
  
  number_images = size(y2, 1);
  numdims = size(y2, 2);
  walk_path = zeros(0, numdims);
  start_index = 0;
  
  success = false;
  % Check if work has been done
  [can_start, final_name, final_exists] = ...
      chunk_start('.', save_filename);
  if (~can_start)
    stack = dbstack();
    warning('Skipping "%s" at line %d in file %s.', ...
            save_filename, stack(1).line, stack(1).file)
    if final_exists
      load([save_filename '.mat'])
      
      % If there is a saved random state, set the current state to
      % it for identical downstream random number generation:
      if (exist('current_random_state', 'var'))
        RandStream.setDefaultStream(current_random_state)
      end
      
      success = true;
    else
      %error('Cannot continue, serial 1 being computed elsewhere.')
      error('  Being computed elsewhere.')
    end
  else
    start_index = ceil(rand(1) .* number_images)
    current_point = y2(start_index, :);
    for m = 1:mmax
      %m
      walk_path(m,:)=current_point;

      while( true )
        if strcmpi(walk_type, 'brownian')
          candidate = current_point + randn(1, numdims) .* ...
              diffusion_constant * sqrt(dt);
        elseif strcmpi(walk_type, 'constantstep')
          direction = zeros( 1, numdims );
          magnitude = 0;
          while( magnitude == 0 )
              direction = randn( 1, numdims );
              magnitude = sqrt(sum( direction.^2 ));
          end

          direction = direction./magnitude;
          candidate = current_point+direction.*diffusion_constant*dt;
        end
        if inhull( candidate, y2, convex_hull )
            current_point = candidate;
            break;
        end
      end

    end
    current_random_state = RandStream.getDefaultStream; 
    save([save_filename '.mat'], 'walk_path', 'start_index', 'current_random_state');
    %%%%%%%%%%%%%%%%

    % Save work
    chunk_finish('.', save_filename); 
  end

  result.walk_path =walk_path ;
  result.start_index = start_index;
  
  success = true;
