% This toolbox implement the 3D deformable registration based on
% Diffeomorphic transformation, LDDMM (default), or optical flow(option 2);
% This is the main code of the toolbox

% The input of this toolbox is:
%%%% 1. Binary images(bi_im) (Please save them into cell format); 2. Gray-level
%%%% images corresponding to the Binary images (gl_im); 3. A template that
%%%% all the binary images need to register.


method = 1; % 1. LDDMM (default); 2. Optical flow;
% bi_im = input Binary images Bi;
% gl_im = input gray-level images Ii;
% template = inpute template;

[nmImg] = size(bi_im,2); % Compute the number of input images.

%% Computing the shape diffeomorphic transformations Fi(); such that Bi(Fi(x)) = template
 
if method==1
    
    for i = 1:nmImg
        [f_X{i}, f_Y{i}, f_Z{i}, rstImg{i}] = Greedy3D_pre(bi_im{i}, templ);
    end
    
elseif method==2

    for i = 1:nmImg
        [f_X{i}, f_Yv{i}, f_Z{i}, rstImg{i}] = ThirionDemon_3D(bi_im{i}, templ);
    end
   
end

%% Applying the transformation Fi() on intensity images. Computing Ii(Fi(x))
for i = 1:nmImg
    Result{i} = interp3(gl_im{i}, f_X{i}, f_Y{i}, f_Z{i},'linear');
end

%% After computing the gray-level image Results, we can visualize the
%% protein locations by averaging the Results
% meanRst = [];
% for i = 1:nmImg
%     meanRst = meanRst + Result{i};
% end
% Rst = meanRst/nmImg;

