function morphing_result=morphing(template, bi_im, gl_im,interp_method)
% This toolbox implement the 3D deformable registration based on
% Diffeomorphic transformation, LDDMM (default), or optical flow(option 2);
% This is the main code of the toolbox

% The input of this toolbox is:
%%%% 1. Binary images(bi_im)  2. Gray-level
%%%% images corresponding to the Binary images (gl_im); 3. A template that
%%%% all the binary images need to register.
method = 1; % 1. LDDMM (default); 2. Optical flow;
% bi_im = input Binary images Bi;
% gl_im = input gray-level images Ii;
% template = inpute template;

% Author: Wei Wang
%
% Copyright (C) 2012 Murphy Lab
% Lane Center for Computational Biology
% School of Computer Science
% Carnegie Mellon University
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu

%% Computing the shape diffeomorphic transformations Fi(); such that Bi(Fi(x)) = template

if method==1
    [f_X, f_Y, f_Z, rstImg] = Greedy3D_pre(bi_im, template);
elseif method==2
    [f_X, f_Yv, f_Z, rstImg] = ThirionDemon_3D(bi_im, template);
end

%% Applying the transformation Fi() on intensity images. Computing Ii(Fi(x))

morphing_result = interp3(gl_im, f_X, f_Y, f_Z,interp_method);

