function[Xxy, Yxy, Zxy, sXY] = ThirionDemon_3D(S, T, options)

if ~exist('options','var')
    iterN = 1200;
    lemda = 0.05;    % Step length
    e = 0.001;      % A very small number to make the denominator larger than 0
    sigma = 0.6;    % Gaussina sigma
else
    iterN = options.iterN;
    lemda = options.lambda;
    e = options.e;
    sigma = options.sigma;
end


[sizeY, sizeX, sizeZ] = size(S);
[Xxy, Yxy, Zxy] = meshgrid(1:sizeX, 1:sizeY, 1:sizeZ);
X = Xxy;    Y = Yxy;    Z = Zxy;

for i = 1:iterN

sXY = interp3(S, Xxy, Yxy, Zxy);

sXY(isnan(sXY))=0;

% ind = find(isnan(sXY));
% numNaN = size(ind,1);
% for j = 1:numNaN
%     sXY(ind(j)) = median([sXY(ind(j)-3) sXY(ind(j)-2) sXY(ind(j)-1) sXY(ind(j)+1) sXY(ind(j)+2) sXY(ind(j)+3)]);
% end

%figure(3),render_data(sXY); drawnow;

% imshow(sXY, []); drawnow;
% pause(0.0000000000001);

[Sx, Sy, Sz] = gradient(sXY);

axy = ((sXY - T).*Sx) ./ (Sx.^2+Sy.^2+Sz.^2+abs(sXY - T).^2+e);
bxy = ((sXY - T).*Sy) ./ (Sx.^2+Sy.^2+Sz.^2+abs(sXY - T).^2+e);
cxy = ((sXY - T).*Sz) ./ (Sx.^2+Sy.^2+Sz.^2+abs(sXY - T).^2+e);

% Gau=fspecial('gaussian',[3,3],sigma);
% ui = imfilter(axy, Gau, 'same');
% vi = imfilter(bxy, Gau, 'same');
% wi = imfilter(cxy, Gau, 'same');

ui = smooth3(axy, 'gaussian', [3 3 3], sigma);
vi = smooth3(bxy, 'gaussian', [3 3 3], sigma);
wi = smooth3(cxy, 'gaussian', [3 3 3], sigma);
ui = lemda*ui;
vi = lemda*vi;
wi = lemda*wi;

% ui = lemda*axy;
% vi = lemda*bxy;
% wi = lemda*cxy;

Xxy = interp3(Xxy, X - ui, Y - vi, Z - wi);
Yxy = interp3(Yxy, X - ui, Y - vi, Z - wi);
Zxy = interp3(Zxy, X - ui, Y - vi, Z - wi);

iterts = num2str(i);
maxIter = num2str(iterN);
notif = ['Current Iteration: ' iterts,'     ','Max Iteration: ' maxIter];
disp(notif);

end



