function[f_X, f_Y, f_Z, rstImg] = Greedy3D_pre(S, T, options)
% The input of this function is the source image 'S' and the target image 'T'.
% The input 'option' contains the parameters of LDDMM, and it is optional.
% If there is 'option' input, it will use the inputed one, if there is no
% 'option' input, the code will use the default parameters.
% The 'L = alpha*<> + gamma*Id' operator contains 'alpha' which is the
% coefficient of Lapacian operator and 'gamma' which is the coefficient of
% the identity matrix.
% The output of this funtion is the deformation field as well as velocity
% field, with def(x, t+1) = def(x+tau*V, t). Therefore, the size of the
% deformation field is [nx, ny, nt+1] and size of velocity field is [nx, ny, nt]

if ~exist('options','var') % Default parameters of LDDMM
    alpha = 0.8;          % coefficient of Lapacian operator
    gamma = 0.04;       % Coefficient of the Identity
    tau = 0.032;           % Step length of LDDMM;
    max_it = 200;        % Max iteration
else    % User inputed parameters
    alpha = options.alpha;
    gamma = options.gamma;
    tau = options.tau;
    max_it = options.max_it;    
end


  src = S;
  % initialization parameters
  [M, N, P] = size(S);
  [X_0,Y_0,Z_0] = meshgrid(1:N, 1:M, 1:P);
  dist1 = 0;
  kkx = (2*pi/N)*[0:(N/2-1) (-N/2):(-1)];
  kky = (2*pi/M)*[0:(M/2-1) (-M/2):(-1)];
  kkz = (2*pi/P)*[0:(P/2-1) (-P/2):(-1)]; 
  [KX,KY,KZ]  = meshgrid(kkx,kky,kkz);                               
  delsq = 2*alpha*((1-cos(KX))/(1/1^2) + (1-cos(KY))/(1/1^2) + (1-cos(KZ))/(1/1^2))+ gamma;
  delsq = -delsq.^2;
  delsq(1,1,1) = 1;
  X_total1 = X_0; Y_total1 = Y_0; Z_total1 = Z_0;
  distar1 = [dist1];
  def_X(:,:,:,1) = X_0;
  def_Y(:,:,:,1) = Y_0;
  def_Z(:,:,:,1) = Z_0;

  
for j = 1: max_it       
  %compute force F = -(T - src).*grad(src)
  [dIx1,dIy1,dIz1] = gradient(src);
  im_diff = T - src;% Computing the difference in images
  Fx1 = -im_diff.*dIx1;
  Fy1 = -im_diff.*dIy1;
  Fz1 = -im_diff.*dIz1;
  
  % Contribution of the source image
  % Computing the velocity by solving (LtL)v = F for v
  fhat_x = fftn(Fx1);
  Vx1 = real(ifftn(fhat_x./delsq));
  Vx1 = Vx1 - Vx1(1,1,1);  % Specify arbitrary constant by forcing corner u = 0.
  fhat_y = fftn(Fy1);
  Vy1 = real(ifftn(fhat_y./delsq));
  Vy1 = Vy1 - Vy1(1,1,1);  % Specify arbitrary constant by forcing corner u = 0.
  fhat_z = fftn(Fz1);
  Vz1 = real(ifftn(fhat_z./delsq));
  Vz1 = Vz1 - Vz1(1,1,1); 
  
  Vx1(:,1,:) = 0;Vx1(:,N,:) = 0;Vx1(1,:,:) = 0;Vx1(M,:,:) = 0;Vx1(:,:,1)=0;Vx1(:,:,P)=0;
  Vy1(:,1,:) = 0;Vy1(:,N,:) = 0;Vy1(1,:,:) = 0;Vy1(M,:,:) = 0;Vy1(:,:,1)=0;Vy1(:,:,P)=0;
  Vz1(:,1,:) = 0;Vz1(:,N,:) = 0;Vz1(1,:,:) = 0;Vz1(M,:,:) = 0;Vz1(:,:,1)=0;Vz1(:,:,P)=0;
  
  Vx1(isnan(Vx1))=0; Vy1(isnan(Vy1))=0; Vz1(isnan(Vz1))=0; 
  % Computing the distance by (1/N*M)*sqrt(dx2+ dy2);
  dx2 = mean2((-del2(Vx1)*6*alpha + gamma*Vx1).^2);
  dy2 = mean2((-del2(Vy1)*6*alpha + gamma*Vy1).^2);
  dz2 = mean2((-del2(Vz1)*6*alpha + gamma*Vz1).^2);
  % Vx(:,:,j) = Vx1; Vy(:,:,j) = Vy1; Vz(:,:,j) = Vz1; % Record the velocity field.

  dist1 = dist1 + tau*sqrt(dx2 + dy2 + dz2);
  
  % Update the deformation field by Eularian reference
  X_c = X_0 + tau*Vx1;  
  Y_c = Y_0 + tau*Vy1;
  Z_c = Z_0 + tau*Vz1;
  X_total1 = interp3(X_total1,X_c,Y_c,Z_c);
  Y_total1 = interp3(Y_total1,X_c,Y_c,Z_c);
  Z_total1 = interp3(Z_total1,X_c,Y_c,Z_c);

  X_total1(isnan(X_total1))=0; 
  Y_total1(isnan(Y_total1))=0; 
  Z_total1(isnan(Z_total1))=0;
%   def_X(:,:,:,j+1) = X_total1;    % % Record the deformation field. 
%   def_Y(:,:,:,j+1) = Y_total1;
%   def_Z(:,:,:,j+1) = Z_total1;
  

  % Show the cartoon of registration process.
  src = interp3(S, X_total1, Y_total1, Z_total1);
  src(isnan(src))=0; 
  % Display the images.
  
  
%   if mod(j, 5)==0
%   figure(111);
%   subplot(1,2,1), render_data(src);drawnow;
%   subplot(1,2,2), render_data(T);drawnow;
%   title(num2str(j));
%     end



  % Show registration error.
  error = src - T;
  errReg_str = num2str(norm(error(:)));
  iterts = num2str(j);
  notif = ['Iteration: ' iterts,'  ', 'Reg Error: ', errReg_str];
  disp(notif);
  
end  

f_X = X_total1;
f_Y = Y_total1;
f_Z = Z_total1;
rstImg = src;

