function[distar1, distar2] = Greedy3D_lambda_pre_nonperiodic(S, T, lambda, options)
% The input of this function is the source image 'S' and the target image 'T'.
% The input 'option' contains the parameters of LDDMM, and it is optional.
% If there is 'option' input, it will use the inputed one, if there is no
% 'option' input, the code will use the default parameters.
% The 'L = alpha*<> + gamma*Id' operator contains 'alpha' which is the
% coefficient of Lapacian operator and 'gamma' which is the coefficient of
% the identity matrix.
% The output of this funtion is the deformation field as well as velocity
% field, with def(x, t+1) = def(x+tau*V, t). Therefore, the size of the
% deformation field is [nx, ny, nt+1] and size of velocity field is [nx, ny, nt]

if ~exist('options','var') % Default parameters of LDDMM
    alpha = 0.8;          % coefficient of Lapacian operator
    gamma = 0.04;       % Coefficient of the Identity
    tau = .04;           % Step length of LDDMM;
    max_it = 201;        % Max iteration
else    % User inputed parameters
    alpha = options.alpha;
    gamma = options.gamma;
    tau = options.tau;
    max_it = options.max_it;    
end

if lambda<0
    disp('Lambda should be a positive number');
    lambda = abs(lambda);
end

src = S;
trg = T;

src2 = src;
trg2 = trg;

scale = [64,64,size(src,3)];
use_second_version = true;
kernel = Greedy3D_kernel_resampled( scale, alpha, gamma, use_second_version);


  % initialization parameters
  [M, N, P] = size(S);

  [X_0,Y_0,Z_0] = meshgrid(1:N, 1:M, 1:P);
  dist1 = 0; dist2 = 0;

if false
  kkx = (2*pi/N)*[0:(N/2-1) (-N/2):(-1)];
  kky = (2*pi/M)*[0:(M/2-1) (-M/2):(-1)];
  kkz = (2*pi/P)*[0:(P/2-1) (-P/2):(-1)]; 
  [KX,KY,KZ]  = meshgrid(kkx,kky,kkz);                               
  delsq = 2*alpha*((1-cos(KX))/(1/1^2) + (1-cos(KY))/(1/1^2) + (1-cos(KZ))/(1/1^2))+ gamma;
  delsq = -delsq.^2;
  delsq(1,1,1) = 1;
end

  X_total1 = X_0; Y_total1 = Y_0; Z_total1 = Z_0;
  X_total2 = X_0; Y_total2 = Y_0; Z_total2 = Z_0;
  distar1 = [dist1];
  distar2 = [dist2];

%   defs_X(:,:,:,1) = X_0;   % def(:,0) = X0;
%   defs_Y(:,:,:,1) = Y_0;
%   defs_Z(:,:,:,1) = Z_0;
%   deft_X(:,:,:,1) = X_0;
%   deft_Y(:,:,:,1) = Y_0;
%   deft_Z(:,:,:,1) = Z_0;
  
for j = 1: max_it       
  disp( num2str(j) )
  %compute force F = -(T - src).*grad(src)
  [dIx1,dIy1,dIz1] = gradient(src2);
  [dIx2,dIy2,dIz2] = gradient(trg2);
  im_diff = trg2 - src2;% Computing the difference in images

  Fx1 = -im_diff.*dIx1;
  Fy1 = -im_diff.*dIy1;
  Fz1 = -im_diff.*dIz1;
  Fx2 = im_diff.*dIx2;
  Fy2 = im_diff.*dIy2;	
  Fz2 = im_diff.*dIz2;

  
  % Contribution of the source image
  % Computing the velocity by solving (LtL)v = F for v

%  fhat_x = fftn(Fx1);
%  Vx1 = real(ifftn(fhat_x./delsq));

   Vx1 = real(convnfft_fast(Fx1,kernel));
   Vx1 = Vx1 - Vx1(1,1);  % Specify arbitrary constant by forcing corner u = 0.

%  fhat_y = fftn(Fy1);
%  Vy1 = real(ifftn(fhat_y./delsq));
  Vy1 = real(convnfft_fast(Fy1,kernel)); 
 Vy1 = Vy1 - Vy1(1,1);  % Specify arbitrary constant by forcing corner u = 0.

%  fhat_z = fftn(Fz1);
%  Vz1 = real(ifftn(fhat_z./delsq));
  Vz1 = real(convnfft_fast(Fz1,kernel));
  Vz1 = Vz1 - Vz1(1,1);
  
  Vx1(:,1,:) = 0;Vx1(:,N,:) = 0;Vx1(1,:,:) = 0;Vx1(M,:,:) = 0;Vx1(:,:,1)=0;Vx1(:,:,P)=0;
  Vy1(:,1,:) = 0;Vy1(:,N,:) = 0;Vy1(1,:,:) = 0;Vy1(M,:,:) = 0;Vy1(:,:,1)=0;Vy1(:,:,P)=0;
  Vz1(:,1,:) = 0;Vz1(:,N,:) = 0;Vz1(1,:,:) = 0;Vz1(M,:,:) = 0;Vz1(:,:,1)=0;Vz1(:,:,P)=0;
  
  % Computing the distance by (1/N*M)*sqrt(dx2+ dy2);
  dx2 = (-del2(Vx1)*6*alpha + gamma*Vx1).^2;
  dy2 = (-del2(Vy1)*6*alpha + gamma*Vy1).^2;
  dz2 = (-del2(Vz1)*6*alpha + gamma*Vz1).^2;

  dx2 = mean(dx2(:));
  dy2 = mean(dy2(:));
  dz2 = mean(dz2(:));

  % Vx(:,:,j) = Vx1; Vy(:,:,j) = Vy1; Vz(:,:,j) = Vz1; % Record the velocity field.

  dist1 = dist1 + tau*sqrt(dx2 + dy2 + dz2);
  distar1 = [distar1, dist1];  % Record the distance
  
  % Update the deformation field by Eularian reference
  X_c = X_0 + tau*Vx1;  
  Y_c = Y_0 + tau*Vy1;
  Z_c = Z_0 + tau*Vz1;
  X_total1 = interp3(X_total1,X_c,Y_c,Z_c);
  Y_total1 = interp3(Y_total1,X_c,Y_c,Z_c);
  Z_total1 = interp3(Z_total1,X_c,Y_c,Z_c);

%   defs_X(:,:,:,j+1) = X_total1;    % % Record the deformation field. 
%   defs_Y(:,:,:,j+1) = Y_total1;
%   defs_Z(:,:,:,j+1) = Z_total1;
   
  % contribution of target image
  
   %fhat_x = fftn(Fx2);
   %Vx2 = real(ifftn(fhat_x./delsq));
   Vx2 = real(convnfft_fast(Fx2,kernel));
   Vx2 = Vx2 - Vx2(1,1);  % Specify arbitrary constant by forcing corner u = 0.  

  %fhat_y = fftn(Fy2);
  %Vy2 = real(ifftn(fhat_y./delsq));
  Vy2 = real(convnfft_fast(Fy2,kernel));
  Vy2 = Vy2 - Vy2(1,1);  % Specify arbitrary constant by forcing corner u = 0.

  %fhat_z = fftn(Fz2);
  %Vz2 = real(ifftn(fhat_z./delsq));
  Vz2 = real(convnfft_fast(Fz2,kernel));
  Vz2 = Vz2 - Vz2(1,1);
  
%   Vx2(:,1) = 0;Vx2(:,N) = 0;Vx2(1,:) = 0;Vx2(M,:) = 0;
%   Vy2(:,1) = 0;Vy2(:,N) = 0;Vy2(1,:) = 0;Vy2(M,:) = 0;
%   Vz2(:,1) = 0;Vz2(:,N) = 0;Vz2(1,:) = 0;Vz2(M,:) = 0;
  Vx2(:,1,:) = 0;Vx2(:,N,:) = 0;Vx2(1,:,:) = 0;Vx2(M,:,:) = 0;Vx2(:,:,1)=0;Vx2(:,:,P)=0;
  Vy2(:,1,:) = 0;Vy2(:,N,:) = 0;Vy2(1,:,:) = 0;Vy2(M,:,:) = 0;Vy2(:,:,1)=0;Vy2(:,:,P)=0;
  Vz2(:,1,:) = 0;Vz2(:,N,:) = 0;Vz2(1,:,:) = 0;Vz2(M,:,:) = 0;Vz2(:,:,1)=0;Vz2(:,:,P)=0;
  
  dx22 = (-del2(Vx2)*6*alpha + gamma*Vx2).^2;
  dy22 = (-del2(Vy2)*6*alpha + gamma*Vy2).^2;
  dz22 = (-del2(Vz2)*6*alpha + gamma*Vz2).^2;
  dx22 = mean(dx22(:));
  dy22 = mean(dy22(:));
  dz22 = mean(dz22(:));

  dist2 = dist2 + tau*sqrt(dx22 + dy22 + dz22);
  distar2 = [distar2,dist2];
 
  X_c = X_0 + tau*Vx2;
  Y_c = Y_0 + tau*Vy2;
  Z_c = Z_0 + tau*Vz2;
  
  X_total2 = interp3(X_total2,X_c,Y_c,Z_c);
  Y_total2 = interp3(Y_total2,X_c,Y_c,Z_c);
  Z_total2 = interp3(Z_total2,X_c,Y_c,Z_c);
  
%   deft_X(:,:,:,j+1) = X_total2;    % % Record the deformation field. 
%   deft_Y(:,:,:,j+1) = Y_total2;
%   deft_Z(:,:,:,j+1) = Z_total2;

  X_total1(isnan(X_total1))=0; 
  Y_total1(isnan(Y_total1))=0; 
  Z_total1(isnan(Z_total1))=0;
  X_total2(isnan(X_total2))=0; 
  Y_total2(isnan(Y_total2))=0; 
  Z_total2(isnan(Z_total2))=0;

keyboard


  % Show the cartoon of registration process.
  src2 = interp3(S, X_total1, Y_total1, Z_total1);
  trg2 = interp3(T, X_total2, Y_total2, Z_total2);

  trg2(isnan(trg2))=0;  src2(isnan(src2))=0; 
  % Display the images.
  if(mod(j,20)==1)
  figure(111);
  subplot(1,2,1), render_data(src2);drawnow;
  subplot(1,2,2), render_data(trg2);drawnow;
  curIt = num2str(j);
  title(curIt);
  end
  
  % Show registration error.
  error = src2 - trg2;
  errReg_str = num2str(norm(error(:)));
  iterts = num2str(j);
  notif = ['Iteration: ' iterts,'  ', 'Reg Error: ', errReg_str];
  disp(notif);
  
end  


% wholeDis = distar1(end) + distar2(end);
% if lambda >= distar1/distar2
%     [value,ind] = min(abs(distar1 - (1/(1+lambda))*wholeDis));
%     img = interp3(S, defs_X(:,:,ind), defs_Y(:,:,ind),defs_Z(:,:,ind));
% else
%     [value,ind] = min(abs(distar1 - (lambda/(1+lambda))*wholeDis));
%     img = interp3(T, deft_X(:,:,ind), deft_Y(:,:,ind),deft_Z(:,:,ind));    
% end
% 
% figure, imshow(img,[]);
