function [theta] = corner_angles(image, radius)
  % Estimate angles of hypothetical corners at each pixel. Based on
  % Rosin 1999, "Measuring Corner Properties."
  % Created 2011-08-11 22:00 tebuck.
  % 2011-08-12 11:43 tebuck: Assume a circular cone for current 3D
  % version.
    
  a = image;
  r = radius;
  a = padarray(a, r .* ones(1, ndims(a)), 'both');
  c = [];
  if ndims(a) == 2
    %c = (sqrt(repmat(-r:r, r*2+1, 1).^2 + repmat((-r:r)', 1, r*2+1).^2) <= r) * 1.;
    c = double(sqrt(repmat(-r:r, r*2+1, 1).^2 + repmat((-r:r)', 1, r*2+1).^2) <= r);
  elseif ndims(a) == 3
    c = double(...
      sqrt(repmat(-r:r, [r*2+1, 1, r*2+1]).^2 ...
           + repmat((-r:r)', [1, r*2+1, r*2+1]).^2 ...
           + repmat(shiftdim(-r:r, -1), [r*2+1, r*2+1, 1]).^2 ...
           ) <= r);
  end
  %m0 = imfilter(a.^0, c);
  %n = ones(size(a)) .* sum(c(:));
  n = sum(c(:));
  %m1 = imfilter(a.^1, c);
% $$$   m1 = imfilter(a, c);
% $$$   m2 = imfilter(a.^2, c);
% $$$   m3 = imfilter(a.^3, c);
  m1 = convnfft(a, c, 'same');
  m2 = convnfft(a.^2, c, 'same');
  m3 = convnfft(a.^3, c, 'same');
  t = sqrt(-3 .* m1.^2 .* m2.^2 + 4 .* m1.^3 .* m3 + 4 .* m2.^3 .* n - 6 .* m1 .* m2 .* m3 .* n + m3.^2 .* n.^2);
  b = (m1 .* m2 - n .* m3 + t) ./ (2 * (m1.^2 - n .* m2));
  d = (m1 .* m2 - n .* m3 - t) ./ (2 * (m1.^2 - n .* m2));
  m = (m1 - n .* d) ./ (b - d);
  theta = [];
  %theta = m ./ n .* 2 * pi;
  if ndims(a) == 2
    theta = (n - m) ./ n .* 2 * pi;
  elseif ndims(a) == 3
    % theta = phi * 2:
    theta = acos((n - m) ./ n) * 2.;
  end
  %theta(isnan(theta)) = pi;
  %ndims(a)
  theta(isnan(theta)) = 0;
  if ndims(a) == 2
    theta = theta((r + 1):(end - r), (r + 1):(end - r));
  elseif ndims(a) == 3
    theta = theta((r + 1):(end - r), (r + 1):(end - r), (r + 1):(end - r));
  end
