function [result, success] = compute_walk_path_shapes(...
  image_function, shape_space, walk_type, walk_path, save_filenames, registration_options, convergence_error_function, number_walk_frames_to_compute)
  % Arguments:
  % image_function: takes an index and returns the image of that index.
  % shape_space: cell array containing the positions of shapes in the shape space (in the same order as image_function's indices), the convex hull of the same, the Delaunay tessellation of the positions, and, optionally, the distance_matrix used to compute all of these.
  % walk_type: 'constantstep' for constant step size or 'brownian' for Brownian motion.
  % walk_path: positions in the shape space for each frame to be synthesized.
  % save_filenames: cell array of paths at which to save each frame.
  % registration_options: options passed to Greedy3D_* LDDMM code.
  % convergence_error_function: eventually just passed along as part of registration_options.
  % number_walk_frames_to_compute: allows computing only part of the path at a time.
  %   
  % 2013-02-11 tebuck: if shape_space is a cell array of length 4, use the fourth argument (the distances matrix used to compute the shape space) to do faster interpolations.
  
  %error('Implementation yet unfinished below this line!')

  %write_images = true; 
  write_images = false; 
  
  
  result = [];
  
  %success = false;
  success = true;
  % [y2, convex_hull, tes] = shape_space{:}; 
  [y2, convex_hull, tes] = shape_space{1:3}; 
  if length(shape_space) > 3
    distance_matrix = shape_space{4};
  end
  number_masks = size(walk_path, 1); 
  %for path_index = 1:number_masks
  for path_index = 1:min(number_masks, number_walk_frames_to_compute)
    % Check if work has been done
    save_filename = save_filenames{path_index}; 
    [can_start, final_name, final_exists] = ...
        chunk_start('.', save_filename);
    if (~can_start)
      stack = dbstack();
      warning('Skipping "%s" at line %d in file %s.', ...
              save_filename, stack(1).line, stack(1).file)
      if final_exists
        if strcmpi(walk_type, 'constantstep')
          load([save_filename '.mat'], 'img')
          current_frame = img;
        elseif strcmpi(walk_type, 'brownian')
          if (write_images)
            mask_image_filename = [save_filename '_shape.png'];
            if exist(mask_image_filename, 'file')
              write_images = false;
            else
              load([save_filename '.mat'], 'r')
              current_frame = window_decompress_image(...
                r.interpolated_image);
              current_frame = round(current_frame); 
              imwrite(...
                reshape_contrast(current_frame), ...
                mask_image_filename)
            end
          end
        end
      else
        if strcmpi(walk_type, 'constantstep')
          error([...
            'Cannot compute frame ' num2str(path_index) ', constantstep ' ...
            'requires previous iteration to be finished.' ...
                ])
          %break
        else
          success = false;
          warning('  Being computed elsewhere.')
        end
      end
    else
      novel = walk_path(path_index, :);
      if strcmpi(walk_type, 'brownian')

        registration_options.registration_error_function = convergence_error_function;
        registration_options

        r = render_point_3d_windowed(...
          novel, shape_space, ...
          image_function, 0, registration_options)
        save([save_filename '.mat'], 'r')

      elseif strcmpi(walk_type, 'constantstep')
      end
      % Save work
      %save([save_filename '.mat'], 'r')
      chunk_finish('.', save_filename); 
    end
    
  end

  success = true;
