function [result, success] = compute_shape_space(...
  distances, numdims, explained_variance_threshold, save_filename)
  % [result, success] = compute_shape_space(...
  %   distances, numdims, explained_variance_threshold, save_filename)
  %
  % If explained_variance_threshold is an array with two elements, the second is the maximum allowable dimensionality.
  
  %error('Implementation yet unfinished below this line!')
  
  result = struct();
  result.y2 = [];
  result.convex_hull = [];
  result.tes = [];
  result.numdims = [];
  
  y2 = [];     
  convex_hull = [];
  tes = [];    
  
  success = false;
  % Check if work has been done
  [can_start, final_name, final_exists] = ...
      chunk_start('.', save_filename);
  if (~can_start)
    stack = dbstack();
    warning('Skipping "%s" at line %d in file %s.', ...
            save_filename, stack(1).line, stack(1).file)
    if final_exists
      load([save_filename '.mat'])
      success = true;
    else
      %error('Cannot continue, serial 1 being computed elsewhere.')
      error('  Being computed elsewhere.')
    end
  else
    [y, e] = cmdscale( distances );
    e

    % Determine shape space dimensionality using positive eigenvalues
    % (too bad some of the negative ones can be large):
    if numdims == 0
      cs = cumsum(e .* (e >= 0));
      sufficient_dimensionalities = ...
          find(cs ./ cs(end) >= ...
               explained_variance_threshold(1)); 
      numdims = sufficient_dimensionalities(1);
      if length(explained_variance_threshold) > 1
        numdims = min(numdims, explained_variance_threshold(2));
      end
    end
    if numdims > size(y, 2)
      warning(['numdims = ', num2str(numdims), ' > size(y, 2) = ', num2str(size(y, 2))])
      numdims = size(y, 2);
    end
    y2 = y(:,1:numdims);

    convex_hull = convhulln( y2 );
    %crashes:
    %convex_hull = convhulln( y2, {'Qt','Qx', 'T1'} );
    tes = delaunayn(y2);

    save([save_filename '.mat'], 'y2', 'convex_hull', 'tes', 'numdims');
    %%%%%%%%%%%%%%%%

    % Save work
    chunk_finish('.', save_filename); 
  end

  result.y2 = y2;
  result.convex_hull = convex_hull;
  result.tes = tes;
  result.numdims = numdims;
  
  success = true;
