function [result, success] = compute_registration_distance_matrix(...
  registration_filenames, image_size, window_size, reference_index, save_filename)
  % [result, success] = compute_registration_distance_matrix(...
  %   registration_filenames, image_size, reference_index, save_filename)
  %
  %   
  
  %error('Implementation yet unfinished below this line!')
  
  %number_images = length(images); 
  distances = []; 
  result = [];
  success = false;
  % Check if work has been done
  [can_start, final_name, final_exists] = ...
      chunk_start('.', save_filename);
  if (~can_start)
    stack = dbstack();
    warning('Skipping "%s" at line %d in file %s.', ...
            save_filename, stack(1).line, stack(1).file)
    if final_exists
      load([save_filename '.mat'])
      success = true;
    else
      %error('Cannot continue, serial 1 being computed elsewhere.')
      error('  Being computed elsewhere.')
    end
  else
    % Try to construct the distance matrix approximation:
    distances_finished = true;
    number_images = length(registration_filenames) + 1;
    for comparison_index = 1:number_images - 1
      comparison_filename = registration_filenames{comparison_index}; 
      if ~exist([comparison_filename '.mat'], 'file')
        distances_finished = false
        break
      end
    end
    if ~distances_finished
      chunk_finish('.', save_filename); 
      stack = dbstack();
      error('Registrations incomplete or incorrect filenames at line %d in file %s.', ...
            stack(1).line, stack(1).file)
    else
      M2 = image_size(1)
      N2 = image_size(2)
      P2 = image_size(3)
      [X_0,Y_0,Z_0] = meshgrid(1:N2, 1:M2, 1:P2);
      X_0 = window_compress_image(X_0, window_size);
      Y_0 = window_compress_image(Y_0, window_size);
      Z_0 = window_compress_image(Z_0, window_size);
      identity_map = {X_0, Y_0, Z_0};
      distances = zeros(number_images, number_images);
      comparison_map = [];
      for comparison_index = 1:number_images
        if comparison_index ~= reference_index
          comparison_filename = registration_filenames{comparison_index - (comparison_index > reference_index)}; 
          load([comparison_filename '.mat'], 'r')
          comparison_map = r.source_deformation;
        else
          comparison_map = identity_map;
        end
        for second_index = (comparison_index + 1):number_images
          second_map = [];
          if second_index ~= reference_index
            second_filename = registration_filenames{second_index - (second_index > reference_index)}; 
            load([second_filename '.mat'], 'r')
            second_map = r.source_deformation;
          else
            second_map = identity_map;
          end
          approximate_distance = 0;
          %whos
          for dim_ind = 1:3
            %comparison_map{dim_ind}
            %second_map{dim_ind}
            approximate_distance = approximate_distance + ...
                window_compressed_sum(...
                  window_compressed_power(...
                    window_compressed_subtract(...
                      comparison_map{dim_ind}, second_map{dim_ind}), ...
                    2));
          end
          distances(comparison_index, second_index) = ...
              approximate_distance;
          distances(second_index, comparison_index) = ...
              distances(comparison_index, second_index);
          %distances
        end
      end
      save([save_filename '.mat'], 'distances')
      %%%%%%%%%%%%%%%%

      % Save work
      chunk_finish('.', save_filename); 
    end
  end

  result = distances;
  success = true;
