function [distances, success] = compute_distance_matrix(...
  image_function, number_shapes, save_filename_prefix, registration_options, convergence_error_function)
  % [result, success] = compute_distance_matrix(...
  %   image_function, number_shapes, save_filename_prefix,
  %   registration_options, convergence_error_function)
  %
  %   Computes the LDDMM distance between each pair of shapes and returns a distance matrix in result.
  %   Parallel.
  %   
  %   2012-12-01 tebuck: copied from register_shapes_to_mean_shape.m.
  
  % error('Implementation yet unfinished below this line!')
  
  result = [];
  
  %success = false;
  success = true;
  distances = zeros(number_shapes, number_shapes);
  distances_save_filename = [save_filename_prefix, 'distances'];
  % mkdir(save_filename_prefix)
  mkdir([save_filename_prefix, 'distances'])
  if exist([distances_save_filename, '.mat'], 'file')
    load([distances_save_filename, '.mat'])
    return
  end
  for shape_index = 1:number_shapes
    for shape_index2 = shape_index + 1:number_shapes
      % Check if work has been done
      % save_filename = [save_filename_prefix, num2str(shape_index, '_%d'), num2str(shape_index2, '_%d')]; 
      save_filename = [save_filename_prefix, 'distances', filesep, num2str(shape_index, '%d'), num2str(shape_index2, '_%d')]; 
      [can_start, final_name, final_exists] = ...
          chunk_start('.', save_filename);
      if (~can_start)
        stack = dbstack();
        warning('Skipping "%s" at line %d in file %s.', ...
                save_filename, stack(1).line, stack(1).file)
        if final_exists
          r = [];
          load([save_filename '.mat'], 'r')
          distances(shape_index, shape_index2) = r.total_distance;
        else
          success = false;
          warning('  Being computed elsewhere.')
          distances(shape_index, shape_index2) = nan;
        end
      else
        % Get image
        source = image_function(shape_index); 
        target = image_function(shape_index2); 
        % whos source target
        % Perform work
        registration_options.convergence_registration_error = ...
            convergence_error_function(source, target);
        registration_options.single_sided = false;
        registration_options

        r = Greedy3D_lambda_pre_compressed(...
          source, target, 1, registration_options)
        
        % Save work
        save([save_filename '.mat'], 'r')
        chunk_finish('.', save_filename); 
        
        distances(shape_index, shape_index2) = r.total_distance;
      end
    end
  end
  
  distances = distances + distances';
  
  if success
    save([distances_save_filename, '.mat'], 'distances');
  end
  % success = true;
