% demo3D17
%
% This method shows how to input an image to CellOrganizer. 
% The main idea behind this demo is to show the user they
% can use their own binary images from raw experimental data they can use
% to synthesize protein patterns. The current demo assumes the resolution
% of the images is the same as the images that were used to train the
% protein model. This demo uses the framework synthesized from demo3D15. In 
% this case, the resolution at which the diffeomorphic and vesicle model were
% trained on are different. This demo also shows how to handle that situation
% in CellOrganizer 

% Created: Ivan E. Cao-Berg
%
% Copyright (C) 2012 Murphy Lab
% Lane Center for Computational Biology
% School of Computer Science
% Carnegie Mellon University
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu

curr_path = which('demo3D17.m');
curr_path = curr_path(1:end-10);
cd(curr_path);
clear param

try
 state = rng(3);
catch
 state = RandStream.create('mt19937ar','seed',3);
 RandStream.setDefaultStream(state);
end

outputDirectory = pwd;
param = [];
param.targetDirectory = outputDirectory;
param.prefix = 'synthesizedImages';
param.numberOfSynthesizedImages = 1;
param.compression = 'lzw';
param.microscope = 'none';
param.sampling.method = 'disc';
param.verbose = true;
param.debug = false;
param.synthesis = 'all';

param.resolution.cell = [0.05,0.05,0.04];
param.instance.nucleus = tif2img([pwd filesep '../../../images/HeLa/3D/synthetic/cell1/nucleus.tif']);
param.instance.cell = tif2img([pwd filesep '../../../images/HeLa/3D/synthetic/cell1/cell.tif']);

slml2img( {'../../../models/3D/lamp2.mat'}, param );
