% demo3D14
%
% This demo show the usage of syn2projection, a helper method that makes
% projection using a folder of synthesized images

% Created: Ivan E. Cao-Berg
%
% Copyright (C) 2012 Murphy Lab
% Lane Center for Computational Biology
% School of Computer Science
% Carnegie Mellon University
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu

curr_path = which('demo3D14.m');
curr_path = curr_path(1:end-10);
cd(curr_path);

synthesizedImagesDirectory = '../demo3D01/synthesizedImages/cell1';
if ~exist( synthesizedImagesDirectory )
  warning( 'Synthesized images directory does not exist' );
else
  outputFolder = [ pwd filesep 'projections' ];
  if ~exist( outputFolder )
     mkdir( outputFolder );
  end

  param.verbose = true;
  param.debug = true;
  param.method = 'mean';
  param.compression = 'lzw';

  syn2projection( synthesizedImagesDirectory, ...
      outputFolder, param );
end
