% demo3D09
%
% Synthesize one 3D image from a lysosome model,
% with sampling mode set to 'disc' without convolution.
% Results will be three TIFF files, one each for 
% cell boundary, nuclear boundary, and lysosomes
% in folder "synthesizedImages/cell1"
% Also produce a mean projection of the cell boundary in
% XY, XZ and YZ directions and save it in file 'projection.tif'

% Created: Ivan E. Cao-Berg
%
% Copyright (C) 2012 Murphy Lab
% Lane Center for Computational Biology
% School of Computer Science
% Carnegie Mellon University
%
% July 21, 2012 R.F. Murphy Additional documentation.
% August 10, 2012 I. Cao-Berg Reflected changes from img2projection
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu

curr_path = which('demo3D09.m');
curr_path = curr_path(1:end-10);
cd(curr_path);
clear param

try
    state = rng(3);
catch
    state = RandStream.create('mt19937ar','seed',3);
    RandStream.setDefaultStream(state);
end

outputDirectory = pwd;
param = [];
param.targetDirectory = outputDirectory;
param.prefix = 'synthesizedImages';
param.numberOfSynthesizedImages = 1;
param.image.compression = 'lzw';
param.microscope = 'none';
param.sampling.method = 'disc';
param.verbose = true;

if ~exist( './synthesizedImages/cell1/cell.tif', 'file' )
    slml2img( {'../../../models/3D/lamp2.mat', ...
        }, param );
else
    disp('Image exists on disk. Skipping synthesis.');
end

disp('Loading image to workspace');
img = tif2img( 'synthesizedImages/cell1/cell.tif' );
disp('Making projection');
%icaoberg 8/10/2012
img = im2projection( img );

try
    disp('Attempting to display image. Might fail if X-Windows system not present.');
    imshow( img, [] );
catch
    warning( 'Unable to display image.' );
end

disp('Saving projection');
img2tif( img, 'projection.tif' );
