% demo3D05
%
% Synthesize one 3D image from all object models and a microtubule model, 
% with sampling mode set to 'sampling' and no convolution.
% Results will be seven TIFF files, one each for 
% cell boundary, nuclear boundary, nucleoli, mitochondria, lysosomes, 
% endosomes, and microtubules, in folder "synthesizedImages/cell1"

% Created: Robert F. Murphy
%
% Copyright (C) 2012 Murphy Lab
% Lane Center for Computational Biology
% School of Computer Science
% Carnegie Mellon University
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu

curr_path = which('demo3D05.m');
curr_path = curr_path(1:end-10);
cd(curr_path);
clear param

try
 state = rng(3);
catch
 state = RandStream.create('mt19937ar','seed',3);
 RandStream.setDefaultStream(state);
end

outputDirectory = pwd;
param.targetDirectory = outputDirectory;
param.prefix = 'synthesizedImages';
param.numberOfSynthesizedImages = 1;
param.compression = 'lzw';
param.microscope = 'none';
param.sampling.method = 'sampled';
param.verbose = true;

slml2img( {'../../../models/3D/lamp2.mat', ...
  '../../../models/3D/mit.mat', ...
  '../../../models/3D/nuc.mat', ...
  '../../../models/3D/tfr.mat', ...
  '../../../models/3D/centro.mat'...
  '../../../models/3D/tub.mat'
  }, param );
