function demo2D01( option )
% demo2D01
%
% Trains a 2D generative model of protein location

% Author: Ivan E. Cao-Berg (icaoberg@scs.cmu.edu)
%
% Copyright (C) 2012 Murphy Lab
% Lane Center for Computational Biology
% School of Computer Science
% Carnegie Mellon University
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu
curr_path = which('demo2D01.m');
curr_path = curr_path(1:end-10);
cd(curr_path);

clc;

if nargin == 0
    fprintf(1,'%s\n', 'demo2D02 - Train a 2D generative model' );
    fprintf(1,'%s\n%s\n%s\n%s\n%s\n', 'Select a dataset to download','(1) LAM', '(2) Mit', '(3) Nuc', '(4) TfR' );
    option = input('? ');
end

switch option
    case 1
        pattern = 'lam';
        directory = [ pwd filesep 'LAM' ];
    case 2
        pattern = 'mit';
        directory = [ pwd filesep 'Mit' ];
    case 3
        pattern = 'nuc';
        directory = [ pwd filesep 'Nuc' ];
    case 4
        pattern = 'tfr';
        directory = [ pwd filesep 'TfR' ];
    otherwise
        warning( 'CellOrganizer: Unknown option.' );
        return
end

tarball = [ 'hela2d-' pattern '.tgz' ];
url = 'http://murphylab.web.cmu.edu/data/Hela/2D/';

if ~exist( tarball )
    disp('Downloading dataset');
    urlwrite( [ url tarball] , tarball );
    disp('Extracting files');
    untar( tarball );
else
    disp('Pattern found on disk. Extracting files from existing tarball');
    disp('Extracting files');
    system(['tar -xvf ' tarball] );
end

dna = [ directory filesep 'orgdna' ];
cellm = [ directory filesep 'orgcell' ];
protein = [ directory filesep 'orgprot' ];
param.model.filename = [ lower(pattern) '.xml' ];

img2slml( '2D', dna, cellm, protein, param );
