%demo2D00
%
% Synthesize one 2D image from all object models, 
% Results will be one TIFF file, with six slices, one each for 
% cell boundary, nuclear boundary, nucleoli, mitochondria, lysosomes, 
% and endosomes

% Copyright (C) 2012 Murphy Lab
% Lane Center for Computational Biology
% School of Computer Science
% Carnegie Mellon University
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation; either version 2 of the License,
% or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA.
%
% For additional information visit http://murphylab.web.cmu.edu or
% send email to murphy@cmu.edu
curr_path = which('demo2D00.m');
curr_path = curr_path(1:end-10);
cd(curr_path);

try
 state = rng(12345);
catch err
 state = rand( 'seed', 12345 ); %#ok<RAND>
end

outputDirectory = [ pwd filesep 'images' ];
if ~exist( outputDirectory, 'dir' )
  mkdir( outputDirectory );
end

param = [];
param.targetDirectory = outputDirectory;
param.prefix = 'demo2D00';
param.numberOfSynthesizedImages = 1;
param.compression = 'lzw';
param.debug = false;

slml2img( {'../../../models/2D/nucleolus.mat', ...
  '../../../models/2D/endosome.mat', ...
  '../../../models/2D/mitochondrion.mat', ...
  '../../../models/2D/lysosome.mat'}, param );

